
package com.bloodcode.bleexploit;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

public class MainActivity extends Activity {
    private BluetoothAdapter bluetoothAdapter;
    private TextView logView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        logView = new TextView(this);
        setContentView(logView);

        bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
            log("Bluetooth je uključen. Pokrećem BLE skeniranje...");
            bluetoothAdapter.getBluetoothLeScanner().startScan(scanCallback);
        } else {
            log("Bluetooth nije dostupan ili nije uključen!");
        }
    }

    private void log(String msg) {
        Log.d("BLE-POC", msg);
        logView.append(msg + "\n");
    }

    private final ScanCallback scanCallback = new ScanCallback() {
        @Override
        public void onScanResult(int callbackType, ScanResult result) {
            BluetoothDevice device = result.getDevice();
            log("Pronađen uređaj: " + device.getName() + " [" + device.getAddress() + "]");
            // TODO: Dodaj povezivanje i GATT servis hook (privatna nadogradnja)
        }
    };
}
